-- Roblox Electrode Plugin
-- This plugin integrates with the AI backend to generate and paste Lua code

local Plugin = script.Parent
local PluginButton = plugin:CreateToolbar("Electrode"):CreateButton(
    "Generate Code",
    "Generate Lua code with AI",
    "rbxassetid://0" -- You'll need to upload an icon
)

local Widget = plugin:CreateDockWidgetPluginGui(
    "AICodingAssistantWidget",
    DockWidgetPluginGuiInfo.new(
        Enum.InitialDockState.Float,
        false,
        false,
        400,
        300,
        200,
        150
    )
)

-- Create the main frame
local MainFrame = Instance.new("Frame")
MainFrame.Size = UDim2.new(1, 0, 1, 0)
MainFrame.BackgroundColor3 = Color3.fromRGB(255, 255, 255)
MainFrame.Parent = Widget

-- Create title
local Title = Instance.new("TextLabel")
Title.Size = UDim2.new(1, 0, 0, 40)
Title.Position = UDim2.new(0, 0, 0, 0)
Title.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
Title.TextColor3 = Color3.fromRGB(255, 255, 255)
Title.Text = "Electrode"
Title.TextScaled = true
Title.Font = Enum.Font.SourceSansBold
Title.Parent = MainFrame

-- Create API key input
local ApiKeyLabel = Instance.new("TextLabel")
ApiKeyLabel.Size = UDim2.new(1, -20, 0, 20)
ApiKeyLabel.Position = UDim2.new(0, 10, 0, 50)
ApiKeyLabel.BackgroundTransparency = 1
ApiKeyLabel.Text = "API Key:"
ApiKeyLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
ApiKeyLabel.TextScaled = true
ApiKeyLabel.Font = Enum.Font.SourceSans
ApiKeyLabel.Parent = MainFrame

local ApiKeyInput = Instance.new("TextBox")
ApiKeyInput.Size = UDim2.new(1, -20, 0, 30)
ApiKeyInput.Position = UDim2.new(0, 10, 0, 70)
ApiKeyInput.BackgroundColor3 = Color3.fromRGB(248, 249, 250)
ApiKeyInput.BorderColor3 = Color3.fromRGB(233, 236, 239)
ApiKeyInput.Text = ""
ApiKeyInput.PlaceholderText = "Enter your API key..."
ApiKeyInput.TextScaled = true
ApiKeyInput.Font = Enum.Font.SourceSans
ApiKeyInput.Parent = MainFrame

-- Add rounding to ApiKeyInput
local ApiKeyInputCorner = Instance.new("UICorner")
ApiKeyInputCorner.CornerRadius = UDim.new(0, 6)
ApiKeyInputCorner.Parent = ApiKeyInput

-- Create API key submit button
local ApiKeySubmitButton = Instance.new("TextButton")
ApiKeySubmitButton.Size = UDim2.new(0.3, -10, 0, 30)
ApiKeySubmitButton.Position = UDim2.new(0.7, 10, 0, 70)
ApiKeySubmitButton.BackgroundColor3 = Color3.fromRGB(40, 167, 69)
ApiKeySubmitButton.TextColor3 = Color3.fromRGB(255, 255, 255)
ApiKeySubmitButton.Text = "Submit"
ApiKeySubmitButton.TextScaled = true
ApiKeySubmitButton.Font = Enum.Font.SourceSansBold
ApiKeySubmitButton.Parent = MainFrame

-- Add rounding to ApiKeySubmitButton
local ApiKeySubmitButtonCorner = Instance.new("UICorner")
ApiKeySubmitButtonCorner.CornerRadius = UDim.new(0, 6)
ApiKeySubmitButtonCorner.Parent = ApiKeySubmitButton

-- Create prompt input
local PromptLabel = Instance.new("TextLabel")
PromptLabel.Size = UDim2.new(1, -20, 0, 20)
PromptLabel.Position = UDim2.new(0, 10, 0, 110)
PromptLabel.BackgroundTransparency = 1
PromptLabel.Text = "Describe what you want to code:"
PromptLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
PromptLabel.TextScaled = true
PromptLabel.Font = Enum.Font.SourceSans
PromptLabel.Parent = MainFrame

local PromptInput = Instance.new("TextBox")
PromptInput.Size = UDim2.new(1, -20, 0, 80)
PromptInput.Position = UDim2.new(0, 10, 0, 130)
PromptInput.BackgroundColor3 = Color3.fromRGB(248, 249, 250)
PromptInput.BorderColor3 = Color3.fromRGB(233, 236, 239)
PromptInput.Text = ""
PromptInput.PlaceholderText = "Example: Create a script that makes a part move up and down when touched"
PromptInput.TextScaled = true
PromptInput.Font = Enum.Font.SourceSans
PromptInput.MultiLine = true
PromptInput.Parent = MainFrame

-- Add rounding to PromptInput
local PromptInputCorner = Instance.new("UICorner")
PromptInputCorner.CornerRadius = UDim.new(0, 6)
PromptInputCorner.Parent = PromptInput

-- Create code display frame (initially hidden)
local CodeDisplayFrame = Instance.new("Frame")
CodeDisplayFrame.Size = UDim2.new(1, -20, 0, 150)
CodeDisplayFrame.Position = UDim2.new(0, 10, 0, 220)
CodeDisplayFrame.BackgroundColor3 = Color3.fromRGB(248, 249, 250)
CodeDisplayFrame.BorderColor3 = Color3.fromRGB(233, 236, 239)
CodeDisplayFrame.Visible = false
CodeDisplayFrame.Parent = MainFrame

local CodeLabel = Instance.new("TextLabel")
CodeLabel.Size = UDim2.new(1, -20, 0, 20)
CodeLabel.Position = UDim2.new(0, 10, 0, 5)
CodeLabel.BackgroundTransparency = 1
CodeLabel.Text = "Generated Code:"
CodeLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
CodeLabel.TextScaled = true
CodeLabel.Font = Enum.Font.SourceSans
CodeLabel.Parent = CodeDisplayFrame

-- Create ScrollingFrame for code output
local CodeScrollFrame = Instance.new("ScrollingFrame")
CodeScrollFrame.Size = UDim2.new(1, -20, 1, -30)
CodeScrollFrame.Position = UDim2.new(0, 10, 0, 25)
CodeScrollFrame.BackgroundColor3 = Color3.fromRGB(255, 255, 255)
CodeScrollFrame.BorderColor3 = Color3.fromRGB(233, 236, 239)
CodeScrollFrame.ScrollBarThickness = 8
CodeScrollFrame.CanvasSize = UDim2.new(0, 0, 0, 0) -- Will be auto-sized
CodeScrollFrame.Parent = CodeDisplayFrame

-- Add rounding to ScrollFrame
local CodeScrollFrameCorner = Instance.new("UICorner")
CodeScrollFrameCorner.CornerRadius = UDim.new(0, 6)
CodeScrollFrameCorner.Parent = CodeScrollFrame

-- Create TextBox inside ScrollingFrame
local CodeText = Instance.new("TextBox")
CodeText.Size = UDim2.new(1, -10, 1, 0)
CodeText.Position = UDim2.new(0, 0, 0, 0)
CodeText.BackgroundTransparency = 1
CodeText.Text = ""
CodeText.TextColor3 = Color3.fromRGB(0, 0, 0)
CodeText.TextXAlignment = Enum.TextXAlignment.Left
CodeText.TextYAlignment = Enum.TextYAlignment.Top
CodeText.TextWrapped = true
CodeText.Font = Enum.Font.Code
CodeText.TextSize = 14
CodeText.MultiLine = true
CodeText.ClearTextOnFocus = false
CodeText.Parent = CodeScrollFrame

-- Auto-resize canvas when text changes
CodeText:GetPropertyChangedSignal("Text"):Connect(function()
    local textBounds = CodeText.TextBounds
    CodeScrollFrame.CanvasSize = UDim2.new(0, 0, 0, math.max(textBounds.Y + 20, CodeScrollFrame.AbsoluteSize.Y))
end)

local FocusButton = Instance.new("TextButton")
FocusButton.Size = UDim2.new(0.25, -10, 0, 30)
FocusButton.Position = UDim2.new(0, 10, 0, 470)
FocusButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
FocusButton.TextColor3 = Color3.fromRGB(255, 255, 255)
FocusButton.Text = "Focus Code"
FocusButton.TextScaled = true
FocusButton.Font = Enum.Font.SourceSansBold
FocusButton.Parent = MainFrame

-- Add rounding to FocusButton
local FocusButtonCorner = Instance.new("UICorner")
FocusButtonCorner.CornerRadius = UDim.new(0, 6)
FocusButtonCorner.Parent = FocusButton

-- Create generate button
local GenerateButton = Instance.new("TextButton")
GenerateButton.Size = UDim2.new(1, -20, 0, 40)
GenerateButton.Position = UDim2.new(0, 10, 0, 380)
GenerateButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
GenerateButton.TextColor3 = Color3.fromRGB(255, 255, 255)
GenerateButton.Text = "Generate Code"
GenerateButton.TextScaled = true
GenerateButton.Font = Enum.Font.SourceSansBold
GenerateButton.Parent = MainFrame

-- Add rounding to GenerateButton
local GenerateButtonCorner = Instance.new("UICorner")
GenerateButtonCorner.CornerRadius = UDim.new(0, 8)
GenerateButtonCorner.Parent = GenerateButton

-- Create settings button
local SettingsButton = Instance.new("TextButton")
SettingsButton.Size = UDim2.new(0.25, -10, 0, 30)
SettingsButton.Position = UDim2.new(0, 10, 0, 430)
SettingsButton.BackgroundColor3 = Color3.fromRGB(108, 117, 125)
SettingsButton.BorderColor3 = Color3.fromRGB(108, 117, 125)
SettingsButton.Text = "Settings"
SettingsButton.TextColor3 = Color3.fromRGB(255, 255, 255)
SettingsButton.TextScaled = true
SettingsButton.Font = Enum.Font.SourceSansBold
SettingsButton.Parent = MainFrame

-- Add rounding to SettingsButton
local SettingsButtonCorner = Instance.new("UICorner")
SettingsButtonCorner.CornerRadius = UDim.new(0, 6)
SettingsButtonCorner.Parent = SettingsButton

-- Create status label
local StatusLabel = Instance.new("TextLabel")
StatusLabel.Size = UDim2.new(0.7, -10, 0, 30)
StatusLabel.Position = UDim2.new(0.3, 10, 0, 430)
StatusLabel.BackgroundTransparency = 1
StatusLabel.Text = ""
StatusLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
StatusLabel.TextScaled = true
StatusLabel.Font = Enum.Font.SourceSans
StatusLabel.Parent = MainFrame

-- Backend URL (change this to your deployed backend URL)
local BACKEND_URL = "https://electrodeai.org"

-- Theme state
local currentTheme = "light" -- Default to light theme
local currentModel = "gpt" -- Default to GPT

-- Theme colors
local themes = {
    light = {
        background = Color3.fromRGB(255, 255, 255),
        text = Color3.fromRGB(0, 0, 0),
        inputBackground = Color3.fromRGB(248, 249, 250),
        inputBorder = Color3.fromRGB(233, 236, 239)
    },
    dark = {
        background = Color3.fromRGB(40, 40, 40),
        text = Color3.fromRGB(255, 255, 255),
        inputBackground = Color3.fromRGB(60, 60, 60),
        inputBorder = Color3.fromRGB(80, 80, 80)
    }
}

-- Function to make HTTP requests
local function makeRequest(url, method, data)
    -- Check if we're running in a plugin context
    local isPlugin = plugin ~= nil
    if not isPlugin then
        warn("⚠️ NOT RUNNING AS PLUGIN! This script must be installed as a Roblox Studio Plugin.")
        return nil
    end
    
    -- Check if we're in Studio (not in test mode)
    local runService = game:GetService("RunService")
    if not runService:IsStudio() then
        warn("⚠️ Not running in Studio! Please use this plugin in Edit Mode, not in a game.")
        return nil
    end
    
    if runService:IsRunning() then
        warn("⚠️ Cannot make HTTP requests in Test Mode!")
        warn("⚠️ Please STOP the test (press Stop button) and use the plugin in Edit Mode.")
        return nil
    end
    
    local success, result = pcall(function()
        local http = game:GetService("HttpService")
        local response = http:RequestAsync({
            Url = url,
            Method = method,
            Headers = {
                ["Content-Type"] = "application/json"
            },
            Body = data and http:JSONEncode(data) or nil
        })
        return http:JSONDecode(response.Body)
    end)
    
    if success then
        return result
    else
        local errorMsg = tostring(result)
        if string.find(errorMsg, "game server") or string.find(errorMsg, "client") then
            warn("⚠️ HTTP Error: You're in Test Mode or Game Mode!")
            warn("⚠️ SOLUTION: Press the STOP button and use the plugin in Edit Mode only.")
            warn("⚠️ Edit Mode = Normal Studio editing (not running game)")
        else
            warn("HTTP request failed:", result)
        end
        return nil
    end
end

-- Function to get Roblox User ID (for device binding)
local function getRobloxUserId()
    local success, userId = pcall(function()
        return game:GetService("StudioService"):GetUserId()
    end)
    
    if success and userId > 0 then
        return tostring(userId)
    else
        return nil
    end
end

-- Function to validate API key
local function validateApiKey(apiKey)
    local robloxUserId = getRobloxUserId()
    local response = makeRequest(BACKEND_URL .. "/api/validate-key", "POST", {
        api_key = apiKey,
        roblox_user_id = robloxUserId  -- Send user ID for device binding
    })
    
    return response and response.valid
end

-- Model selection state
local currentModel = "gpt" -- Default to GPT

-- Function to generate code
local function generateCode(apiKey, prompt, model)
    local robloxUserId = getRobloxUserId()
    local response = makeRequest(BACKEND_URL .. "/api/generate-code", "POST", {
        api_key = apiKey,
        prompt = prompt,
        model = model,
        roblox_user_id = robloxUserId  -- Send user ID for device binding
    })
    
    if response and response.success then
        return response.code
    else
        return nil, response and response.error or "Unknown error"
    end
end

-- Function to get the current script editor
local function getCurrentScript()
    local selection = game:GetService("Selection")
    local selected = selection:Get()
    
    for _, obj in pairs(selected) do
        if obj:IsA("LuaSourceContainer") then
            return obj
        end
    end
    
    -- If no script is selected, try to find the active script
    local scriptEditor = plugin:GetStudio()
    if scriptEditor then
        -- This is a simplified approach - in a real implementation,
        -- you'd need to use the Roblox Studio API to get the active script
        return nil
    end
    
    return nil
end

-- Function to paste code into script
local function pasteCodeIntoScript(script, code)
    if not script then
        warn("No script selected. Please select a Script or LocalScript in the Explorer.")
        return false
    end
    
    -- Get the current source
    local currentSource = script.Source
    
    -- Check if the script is empty or just has basic structure
    local trimmedSource = string.gsub(currentSource, "^%s*(.-)%s*$", "%1")
    
    if trimmedSource == "" or trimmedSource == "-- Generated by Electrode" then
        -- Empty script or just our marker - replace entirely
        script.Source = "-- Generated by Electrode\n" .. code
    else
        -- Script has content - append at the end
        script.Source = currentSource .. "\n\n-- Generated by Electrode\n" .. code
    end
    
    return true
end

-- Function to hide API key section after validation
local function hideApiKeySection()
    ApiKeyLabel.Visible = false
    ApiKeyInput.Visible = false
    ApiKeySubmitButton.Visible = false
    
    -- Move prompt section up
    PromptLabel.Position = UDim2.new(0, 10, 0, 50)
    PromptInput.Position = UDim2.new(0, 10, 0, 70)
    
    -- Show code display frame
    CodeDisplayFrame.Visible = true
end

-- Function to show API key section
local function showApiKeySection()
    ApiKeyLabel.Visible = true
    ApiKeyInput.Visible = true
    ApiKeySubmitButton.Visible = true
    
    -- Move prompt section down
    PromptLabel.Position = UDim2.new(0, 10, 0, 110)
    PromptInput.Position = UDim2.new(0, 10, 0, 130)
    
    -- Hide code display frame
    CodeDisplayFrame.Visible = false
end

-- Function to update theme
local function updateTheme()
    local theme = themes[currentTheme]
    
    -- Update main frame
    MainFrame.BackgroundColor3 = theme.background
    
    -- Update text colors
    ApiKeyLabel.TextColor3 = theme.text
    PromptLabel.TextColor3 = theme.text
    StatusLabel.TextColor3 = theme.text
    CodeLabel.TextColor3 = theme.text
    CodeText.TextColor3 = theme.text
    
    -- Update input backgrounds and text colors
    ApiKeyInput.BackgroundColor3 = theme.inputBackground
    ApiKeyInput.BorderColor3 = theme.inputBorder
    ApiKeyInput.TextColor3 = theme.text
    ApiKeyInput.PlaceholderText = "Enter your API key..."
    
    PromptInput.BackgroundColor3 = theme.inputBackground
    PromptInput.BorderColor3 = theme.inputBorder
    PromptInput.TextColor3 = theme.text
    PromptInput.PlaceholderText = "Example: Create a script that makes a part move up and down when touched"
    
    -- Update code display frame and scrolling output colors
    CodeDisplayFrame.BackgroundColor3 = theme.inputBackground
    CodeDisplayFrame.BorderColor3 = theme.inputBorder
    if CodeScrollFrame then
        CodeScrollFrame.BackgroundColor3 = theme.inputBackground
        CodeScrollFrame.BorderColor3 = theme.inputBorder
    end
    -- Text color for code output
    if CodeText then
        CodeText.TextColor3 = theme.text
    end
end

-- Function to update model display
local function updateModelDisplay()
    -- This will be handled in the settings dropdown
end

-- Settings dropdown functionality
local settingsOpen = false
local settingsFrame = nil

local function createSettingsDropdown()
    if settingsFrame then
        settingsFrame:Destroy()
        settingsFrame = nil
        settingsOpen = false
        return
    end
    
    settingsOpen = true
    
    -- Create settings frame
    settingsFrame = Instance.new("Frame")
    settingsFrame.Size = UDim2.new(0.8, 0, 0, 120)
    settingsFrame.Position = UDim2.new(0.1, 0, 0, 310)
    settingsFrame.BackgroundColor3 = Color3.fromRGB(248, 249, 250)
    settingsFrame.BorderColor3 = Color3.fromRGB(233, 236, 239)
    settingsFrame.Parent = MainFrame
    
    -- Theme section
    local themeLabel = Instance.new("TextLabel")
    themeLabel.Size = UDim2.new(1, -20, 0, 20)
    themeLabel.Position = UDim2.new(0, 10, 0, 10)
    themeLabel.BackgroundTransparency = 1
    themeLabel.Text = "Theme:"
    themeLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
    themeLabel.TextScaled = true
    themeLabel.Font = Enum.Font.SourceSansBold
    themeLabel.Parent = settingsFrame
    
    local themeButton = Instance.new("TextButton")
    themeButton.Size = UDim2.new(0.4, -5, 0, 25)
    themeButton.Position = UDim2.new(0, 10, 0, 30)
    themeButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
    themeButton.TextColor3 = Color3.fromRGB(255, 255, 255)
    themeButton.Text = currentTheme == "light" and "Light" or "Dark"
    themeButton.TextScaled = true
    themeButton.Font = Enum.Font.SourceSansBold
    themeButton.Parent = settingsFrame
    
    -- Model section
    local modelLabel = Instance.new("TextLabel")
    modelLabel.Size = UDim2.new(1, -20, 0, 20)
    modelLabel.Position = UDim2.new(0, 10, 0, 60)
    modelLabel.BackgroundTransparency = 1
    modelLabel.Text = "AI Model:"
    modelLabel.TextColor3 = Color3.fromRGB(0, 0, 0)
    modelLabel.TextScaled = true
    modelLabel.Font = Enum.Font.SourceSansBold
    modelLabel.Parent = settingsFrame
    
    local modelButton = Instance.new("TextButton")
    modelButton.Size = UDim2.new(0.4, -5, 0, 25)
    modelButton.Position = UDim2.new(0, 10, 0, 80)
    modelButton.BackgroundColor3 = currentModel == "claude" and Color3.fromRGB(255, 69, 0) or Color3.fromRGB(40, 167, 69)
    modelButton.TextColor3 = Color3.fromRGB(255, 255, 255)
    modelButton.Text = currentModel == "claude" and "Claude" or "GPT-4"
    modelButton.TextScaled = true
    modelButton.Font = Enum.Font.SourceSansBold
    modelButton.Parent = settingsFrame
    
    -- Theme button click
    themeButton.MouseButton1Click:Connect(function()
        currentTheme = currentTheme == "light" and "dark" or "light"
        themeButton.Text = currentTheme == "light" and "Light" or "Dark"
        updateTheme()
        
        -- Save theme preference
        pcall(function()
            plugin:SetSetting("Theme", currentTheme)
        end)
        
        StatusLabel.Text = "Theme: " .. (currentTheme == "light" and "Light" or "Dark")
        StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
        wait(1.5)
        StatusLabel.Text = ""
    end)
    
    -- Model button click
    modelButton.MouseButton1Click:Connect(function()
        currentModel = currentModel == "gpt" and "claude" or "gpt"
        modelButton.Text = currentModel == "claude" and "Claude" or "GPT-4"
        modelButton.BackgroundColor3 = currentModel == "claude" and Color3.fromRGB(255, 69, 0) or Color3.fromRGB(40, 167, 69)
        
        -- Save model preference
        pcall(function()
            plugin:SetSetting("SelectedModel", currentModel)
        end)
        
        StatusLabel.Text = "Model: " .. (currentModel == "claude" and "Claude" or "GPT-4")
        StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
        wait(1.5)
        StatusLabel.Text = ""
    end)
end

-- API key submit button click handler
ApiKeySubmitButton.MouseButton1Click:Connect(function()
    local apiKey = ApiKeyInput.Text
    
    if apiKey == "" then
        StatusLabel.Text = "Please enter your API key"
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
        return
    end
    
    -- Update UI
    ApiKeySubmitButton.Text = "Validating..."
    ApiKeySubmitButton.BackgroundColor3 = Color3.fromRGB(108, 117, 125)
    StatusLabel.Text = "Validating API key..."
    StatusLabel.TextColor3 = Color3.fromRGB(0, 123, 255)
    
    -- Validate API key
    if validateApiKey(apiKey) then
        -- Save API key
        pcall(function()
            plugin:SetSetting("ApiKey", apiKey)
        end)
        
        -- Hide API key section
        hideApiKeySection()
        
        StatusLabel.Text = "API key validated successfully!"
        StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
        wait(1.5)
        StatusLabel.Text = ""
    else
        StatusLabel.Text = "Invalid API key. Please check your key and try again."
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
    end
    
    -- Reset button
    ApiKeySubmitButton.Text = "Submit"
    ApiKeySubmitButton.BackgroundColor3 = Color3.fromRGB(40, 167, 69)
end)

-- Enter key support for API key input
ApiKeyInput.FocusLost:Connect(function(enterPressed)
    if enterPressed then
        ApiKeySubmitButton.MouseButton1Click:Fire()
    end
end)

-- Focus button click handler
FocusButton.MouseButton1Click:Connect(function()
    CodeText:CaptureFocus()
    
    FocusButton.Text = "Focused!"
    FocusButton.BackgroundColor3 = Color3.fromRGB(40, 167, 69)
    wait(1.5)
    FocusButton.Text = "Focus Code"
    FocusButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
end)

-- Settings button click handler
SettingsButton.MouseButton1Click:Connect(function()
    createSettingsDropdown()
end)

-- Button click handler
GenerateButton.MouseButton1Click:Connect(function()
    local apiKey = ApiKeyInput.Text
    local prompt = PromptInput.Text
    
    if apiKey == "" then
        StatusLabel.Text = "Please enter your API key"
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
        return
    end
    
    if prompt == "" then
        StatusLabel.Text = "Please enter a description of the code you want"
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
        return
    end
    
    -- Update UI
    GenerateButton.Text = "Generating..."
    GenerateButton.BackgroundColor3 = Color3.fromRGB(108, 117, 125)
    
    local modelName = currentModel == "claude" and "Claude" or "GPT-4"
    StatusLabel.Text = "Generating code with " .. modelName .. "..."
    StatusLabel.TextColor3 = Color3.fromRGB(0, 123, 255)
    
    -- Force reset after 5 seconds to prevent stuck button
    local forceResetActive = true
    spawn(function()
        wait(5)
        if forceResetActive then
            GenerateButton.Text = "Generate Code"
            GenerateButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
            if StatusLabel.Text:find("Generating") then
                StatusLabel.Text = ""
            end
        end
    end)
    
    -- Validate API key first
    if not validateApiKey(apiKey) then
        forceResetActive = false  -- Cancel force reset
        StatusLabel.Text = "Invalid API key. Please check your key and try again."
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
        GenerateButton.Text = "Generate Code"
        GenerateButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
        return
    end
    
    -- Generate code
    local code, error = generateCode(apiKey, prompt, currentModel)
    
    -- Cancel force reset since we're handling it normally
    forceResetActive = false
    
    if code then
        -- Display code in the code window
        CodeText.Text = code
        
        -- Get current script
        local currentScript = getCurrentScript()
        
        -- Try to paste code into script if one is selected
        if currentScript then
            if pasteCodeIntoScript(currentScript, code) then
                local modelName = currentModel == "claude" and "Claude" or "GPT-4"
                StatusLabel.Text = "Code generated with " .. modelName .. " and pasted successfully!"
                StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
            else
                StatusLabel.Text = "Code generated but couldn't paste. Please select a script first."
                StatusLabel.TextColor3 = Color3.fromRGB(255, 193, 7)
            end
        else
            local modelName = currentModel == "claude" and "Claude" or "GPT-4"
            StatusLabel.Text = "Code generated with " .. modelName .. "! Select a script to paste or copy the code."
            StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
        end
        
        -- Clear status after 3 seconds
        wait(3)
        StatusLabel.Text = ""
    else
        StatusLabel.Text = "Error: " .. (error or "Failed to generate code")
        StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
        
        -- Clear error after 3 seconds
        wait(3)
        StatusLabel.Text = ""
    end
    
    -- Reset button
    GenerateButton.Text = "Generate Code"
    GenerateButton.BackgroundColor3 = Color3.fromRGB(102, 126, 234)
end)

-- Plugin button click handler
PluginButton.Click:Connect(function()
    Widget.Enabled = not Widget.Enabled
end)

-- Load saved API key if available
local function loadSavedApiKey()
    local success, savedKey = pcall(function()
        return plugin:GetSetting("ApiKey")
    end)
    
    if success and savedKey then
        ApiKeyInput.Text = savedKey
        
        -- Validate the saved key
        if validateApiKey(savedKey) then
            -- Hide API key section if valid
            hideApiKeySection()
            StatusLabel.Text = "API key loaded successfully!"
            StatusLabel.TextColor3 = Color3.fromRGB(40, 167, 69)
            wait(1.5)
            StatusLabel.Text = ""
        else
            -- Show API key section if invalid
            showApiKeySection()
            StatusLabel.Text = "Saved API key is invalid. Please enter a new one."
            StatusLabel.TextColor3 = Color3.fromRGB(220, 53, 69)
            wait(2)
            StatusLabel.Text = ""
        end
    else
        -- No saved key, show API key section
        showApiKeySection()
    end
end

-- Load saved settings if available
local function loadSavedSettings()
    -- Load model preference
    local success, savedModel = pcall(function()
        return plugin:GetSetting("SelectedModel")
    end)
    
    if success and savedModel then
        currentModel = savedModel
    end
    
    -- Load theme preference
    local success2, savedTheme = pcall(function()
        return plugin:GetSetting("Theme")
    end)
    
    if success2 and savedTheme then
        currentTheme = savedTheme
    end
    
    updateTheme()
end

-- Save API key when changed
ApiKeyInput.FocusLost:Connect(function()
    local apiKey = ApiKeyInput.Text
    if apiKey ~= "" then
        pcall(function()
            plugin:SetSetting("ApiKey", apiKey)
        end)
    end
end)

-- Load saved settings on startup
loadSavedApiKey()
loadSavedSettings()

print("Electrode Plugin loaded successfully!")
print("Backend URL:", BACKEND_URL)
print("Make sure your backend is running and accessible.") 